#include <bits/stdc++.h>

using namespace std;

typedef long long llint;

const int MAXN = 20;
const llint INF = 1e19;

int n;
int x[MAXN], y[MAXN];

vector<pair<int, llint>> v[MAXN];

llint memo[1 << MAXN];

llint dp(int mask) {
  if (memo[mask] != -1) return memo[mask];
  if (mask == (1 << n) - 1) return memo[mask] = 0;
  int i = 0;
  for (; mask & (1 << i); ++i);
  llint ret = INF;
  for (auto &p : v[i])
    ret = min(ret, p.second + dp(mask | p.first));
  return memo[mask] = ret;
}

llint area(int i, int j, int k) {
  return abs((llint)x[i] * (y[j] - y[k]) + (llint)x[j] * (y[k] - y[i]) +
             (llint)x[k] * (y[i] - y[j]));
}

int main(void) {
  scanf("%d", &n);
  for (int i = 0; i < n; ++i) scanf("%d%d", &x[i], &y[i]);

  for (int i = 0; i < n; ++i)
    for (int j = i + 1; j < n; ++j)
      for (int k = j + 1; k < n; ++k) {
        v[i].emplace_back((1 << i) | (1 << j) | (1 << k), area(i, j, k));
        v[j].emplace_back((1 << i) | (1 << j) | (1 << k), area(i, j, k));
        v[k].emplace_back((1 << i) | (1 << j) | (1 << k), area(i, j, k));
      }

  memset(memo, -1, sizeof memo);
  printf("%.8Lf\n", (long double)dp(0) / 2);
  return 0;
}
